/*
 * Decompiled with CFR 0.152.
 */
package com.lianyunzhihui.uniplugin_hwscan;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.hmf.tasks.OnFailureListener;
import com.huawei.hmf.tasks.OnSuccessListener;
import com.huawei.hms.hmsscankit.ScanUtil;
import com.huawei.hms.ml.scan.HmsScan;
import com.huawei.hms.ml.scan.HmsScanAnalyzer;
import com.huawei.hms.ml.scan.HmsScanAnalyzerOptions;
import com.huawei.hms.mlsdk.common.MLFrame;
import com.lianyunzhihui.uniplugin_hwscan.CameraOperation;
import com.lianyunzhihui.uniplugin_hwscan.CommonHandler;
import com.lianyunzhihui.uniplugin_hwscan.HWScanUtils;
import com.lianyunzhihui.uniplugin_hwscan.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MulitiprocessorActivity
extends Activity
implements View.OnClickListener {
    private static final String TAG = "CommonActivity";
    public CameraOperation cameraOperation;
    private boolean isShow;
    public static final String SCAN_RESULT = "result";
    private SurfaceHolder surfaceHolder;
    private CommonHandler handler;
    private int mode = 3;
    private ImageView backBtn;
    private ImageView imgBtn;
    private SurfaceView cameraPreview;
    private SurfaceCallBack surfaceCallBack;
    private RelativeLayout result_layout;
    private JSONObject scanoptions;
    int[] scanTypes = new int[0];
    private TextView tv_title;
    private int SCANPOTHO_CODE = 4377;
    private ArrayList<HmsScan> mHmsScans = new ArrayList();
    private TextView cancelBtn;
    private RelativeLayout tool_navigate;
    private TextView tv_scan_tips;
    private boolean oneCodeReturn;
    public boolean multicodeReturn;
    private boolean identificationNumberReturn;
    private int identificationNumber;
    private boolean identificationMoreMax;

    @RequiresApi(api=24)
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_mulitiprocessor);
        Intent intent = this.getIntent();
        this.mode = intent.getIntExtra("mode", 1);
        this.tool_navigate = (RelativeLayout)this.findViewById(R.id.tool_navigate);
        this.cancelBtn = (TextView)this.findViewById(R.id.scan_result_cancel);
        this.cancelBtn.setOnClickListener(v -> this.rescan());
        this.tv_scan_tips = (TextView)this.findViewById(R.id.tv_scan_tips);
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        this.imgBtn = (ImageView)this.findViewById(R.id.img_btn);
        this.cameraPreview = (SurfaceView)this.findViewById(R.id.surfaceView);
        this.result_layout = (RelativeLayout)this.findViewById(R.id.result_layout);
        this.configScanOptions();
        this.cameraOperation = new CameraOperation();
        this.surfaceCallBack = new SurfaceCallBack();
        this.adjustSurface(this.cameraPreview);
        this.surfaceHolder = this.cameraPreview.getHolder();
        this.isShow = false;
        this.setBackOperation();
        this.setPictureScanOperation();
    }

    @RequiresApi(api=24)
    private void configScanOptions() {
        Intent intent = this.getIntent();
        if (!TextUtils.isEmpty((CharSequence)intent.getStringExtra("scanOptions"))) {
            this.scanoptions = JSON.parseObject((String)intent.getStringExtra("scanOptions"));
        }
        int[] res = new int[]{};
        if (this.scanoptions.containsKey((Object)"scanType")) {
            res = HWScanUtils.scanTypeConversion(this.scanoptions.getJSONArray("scanType"));
        }
        if (res.length <= 0) {
            res = new int[]{0};
        }
        this.scanTypes = res;
        if (this.scanoptions.containsKey((Object)"scanTypeOptions")) {
            JSONObject scanTypeOptions = this.scanoptions.getJSONObject("scanTypeOptions");
            if (scanTypeOptions.containsKey((Object)"scanTitle")) {
                this.tv_title.setVisibility(0);
                this.tv_title.setText((CharSequence)scanTypeOptions.getString("scanTitle"));
            }
            if (scanTypeOptions.containsKey((Object)"showPhotoAlbum") && scanTypeOptions.getBooleanValue("showPhotoAlbum")) {
                this.imgBtn.setVisibility(0);
            } else {
                this.imgBtn.setVisibility(8);
            }
        }
        this.identificationMoreMax = false;
        if ((this.mode == 3 || this.mode == 2) && this.scanoptions.containsKey((Object)"multiOptions")) {
            JSONObject multiOptions = this.scanoptions.getJSONObject("multiOptions");
            if (multiOptions.containsKey((Object)"oneCodeReturn")) {
                this.oneCodeReturn = multiOptions.getBooleanValue("oneCodeReturn");
            }
            if (multiOptions.containsKey((Object)"scanCancelBtnTitle") && !TextUtils.isEmpty((CharSequence)multiOptions.getString("scanCancelBtnTitle"))) {
                this.cancelBtn.setText((CharSequence)multiOptions.getString("scanCancelBtnTitle"));
            }
            if (multiOptions.containsKey((Object)"scanResultTips") && !TextUtils.isEmpty((CharSequence)multiOptions.getString("scanResultTips"))) {
                this.tv_scan_tips.setText((CharSequence)multiOptions.getString("scanResultTips"));
            }
            this.multicodeReturn = false;
            if (multiOptions.containsKey((Object)"multicodeReturn") && multiOptions.getBooleanValue("multicodeReturn")) {
                this.multicodeReturn = true;
            }
            this.identificationNumberReturn = false;
            if (multiOptions.containsKey((Object)"identificationNumberReturn") && multiOptions.getBooleanValue("identificationNumberReturn")) {
                this.identificationNumberReturn = true;
            }
            this.identificationNumber = 1;
            if (multiOptions.containsKey((Object)"identificationNumber") && multiOptions.getIntValue("identificationNumber") > 0) {
                this.identificationNumber = multiOptions.getIntValue("identificationNumber");
            }
            if (multiOptions.containsKey((Object)"identificationMoreMax") && multiOptions.getBooleanValue("identificationMoreMax")) {
                this.identificationMoreMax = true;
            }
        }
    }

    private void adjustSurface(SurfaceView cameraPreview) {
        FrameLayout.LayoutParams paramSurface = (FrameLayout.LayoutParams)cameraPreview.getLayoutParams();
        if (this.getSystemService("window") != null) {
            WindowManager windowManager = (WindowManager)this.getSystemService("window");
            Display defaultDisplay = windowManager.getDefaultDisplay();
            Point outPoint = new Point();
            defaultDisplay.getRealSize(outPoint);
            float sceenWidth = outPoint.x;
            float sceenHeight = outPoint.y;
            if (sceenWidth / 1080.0f > sceenHeight / 1920.0f) {
                float rate = sceenWidth / 1080.0f;
                int targetHeight = (int)(1920.0f * rate);
                paramSurface.width = -1;
                paramSurface.height = targetHeight;
                int topMargin = (int)(-((float)targetHeight - sceenHeight) / 2.0f);
                if (topMargin < 0) {
                    paramSurface.topMargin = topMargin;
                }
            } else {
                int targetWidth;
                float rate = sceenHeight / 1920.0f;
                paramSurface.width = targetWidth = (int)(1080.0f * rate);
                paramSurface.height = -1;
                int leftMargin = (int)(-((float)targetWidth - sceenWidth) / 2.0f);
                if (leftMargin < 0) {
                    paramSurface.leftMargin = leftMargin;
                }
            }
        }
    }

    private void setBackOperation() {
        this.backBtn = (ImageView)this.findViewById(R.id.back_img);
        this.backBtn.setOnClickListener(v -> this.finish());
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (this.mode == 2 || this.mode == 3) {
            this.setResult(0);
        }
        this.finish();
    }

    private void setPictureScanOperation() {
        this.imgBtn.setOnClickListener(v -> {
            Intent pickIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            pickIntent.setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "image/*");
            this.startActivityForResult(pickIntent, this.SCANPOTHO_CODE);
        });
    }

    private void decodeBitmap(Bitmap bitmap) {
        HmsScan[] hmsScans = ScanUtil.decodeWithBitmap((Context)this, (Bitmap)bitmap, (HmsScanAnalyzerOptions)new HmsScanAnalyzerOptions.Creator().setHmsScanTypes(this.scanTypes[0], this.scanTypes).setPhotoMode(true).create());
        if (hmsScans != null && hmsScans.length > 0 && hmsScans[0] != null && !TextUtils.isEmpty((CharSequence)hmsScans[0].getOriginalValue())) {
            Intent intent = new Intent();
            intent.putExtra(SCAN_RESULT, hmsScans[0].getOriginalValue());
            this.setResult(-1, intent);
            this.finish();
        }
    }

    private void decodeMultiAsyn(Bitmap bitmap) {
        MLFrame image = MLFrame.fromBitmap((Bitmap)bitmap);
        HmsScanAnalyzer analyzer = new HmsScanAnalyzer.Creator((Context)this).setHmsScanTypes(this.scanTypes[0], this.scanTypes).create();
        analyzer.analyzInAsyn(image).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<HmsScan>>(){

            public void onSuccess(List<HmsScan> hmsScans) {
                Intent intent = new Intent();
                intent.putExtra("list", true);
                ArrayList<String> list = new ArrayList<String>();
                for (HmsScan scan : hmsScans) {
                    list.add(scan.getOriginalValue());
                }
                intent.putStringArrayListExtra(MulitiprocessorActivity.SCAN_RESULT, list);
                MulitiprocessorActivity.this.setResult(-1, intent);
                MulitiprocessorActivity.this.finish();
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(Exception e) {
                Log.w((String)MulitiprocessorActivity.TAG, (Throwable)e);
            }
        });
    }

    private void decodeMultiSyn(Bitmap bitmap) {
        MLFrame image = MLFrame.fromBitmap((Bitmap)bitmap);
        HmsScanAnalyzer analyzer = new HmsScanAnalyzer.Creator((Context)this).setHmsScanTypes(this.scanTypes[0], this.scanTypes).create();
        SparseArray result = analyzer.analyseFrame(image);
        if (result != null && result.size() > 0 && result.valueAt(0) != null && !TextUtils.isEmpty((CharSequence)((HmsScan)result.valueAt(0)).getOriginalValue())) {
            HmsScan[] info = new HmsScan[result.size()];
            for (int index = 0; index < result.size(); ++index) {
                info[index] = (HmsScan)result.valueAt(index);
            }
            Intent intent = new Intent();
            intent.putExtra(SCAN_RESULT, (Parcelable[])info);
            this.setResult(-1, intent);
            this.finish();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.isShow) {
            this.initCamera();
        } else {
            this.surfaceHolder.addCallback((SurfaceHolder.Callback)this.surfaceCallBack);
        }
    }

    protected void onPause() {
        if (this.handler != null) {
            this.handler.quit();
            this.handler = null;
        }
        this.cameraOperation.close();
        if (!this.isShow) {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this.surfaceCallBack);
        }
        super.onPause();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    private void initCamera() {
        try {
            this.cameraOperation.open(this.surfaceHolder);
            if (this.handler == null) {
                this.handler = new CommonHandler(this, this.cameraOperation, this.mode, this.scanTypes);
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    public int px2dip(float pxValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private void rescan() {
        this.handler.resumePreView();
        this.result_layout.removeAllViews();
        this.tool_navigate.setVisibility(0);
        this.cancelBtn.setVisibility(8);
        this.tv_scan_tips.setVisibility(8);
    }

    public void refreshScanResult(HmsScan[] hmsScans) {
        if (((HmsScan[])hmsScans).length == 1 && this.oneCodeReturn && !this.identificationNumberReturn) {
            Log.d((String)TAG, (String)"refreshScanResult: 111111111111");
            HmsScan hmsScan = hmsScans[0];
            Intent intent = new Intent();
            intent.putExtra(SCAN_RESULT, hmsScan.getOriginalValue());
            intent.putExtra("list", false);
            this.setResult(-1, intent);
            this.finish();
        } else if (this.multicodeReturn) {
            Intent intent;
            ArrayList<String> hms = new ArrayList<String>();
            for (HmsScan scan : hmsScans) {
                hms.add(scan.getOriginalValue());
            }
            if (this.identificationNumberReturn) {
                if (hms.size() == this.identificationNumber || hms.size() > this.identificationNumber && this.identificationMoreMax) {
                    this.cameraOperation.stopPreview();
                    intent = new Intent();
                    intent.putStringArrayListExtra(SCAN_RESULT, hms);
                    intent.putExtra("list", true);
                    this.setResult(-1, intent);
                    this.finish();
                }
            } else {
                this.cameraOperation.stopPreview();
                intent = new Intent();
                intent.putStringArrayListExtra(SCAN_RESULT, hms);
                intent.putExtra("list", true);
                this.setResult(-1, intent);
                this.finish();
            }
        } else {
            this.cameraOperation.stopPreview();
            Log.d((String)TAG, (String)"refreshScanResult: 222222222222");
            this.tool_navigate.setVisibility(8);
            this.cancelBtn.setVisibility(0);
            this.tv_scan_tips.setVisibility(0);
            this.mHmsScans.clear();
            this.result_layout.removeAllViews();
            float heightScaleFactor = (float)((double)this.result_layout.getHeight() / 1920.0);
            float widthScaleFactor = (float)((double)this.result_layout.getWidth() / 1080.0);
            for (int i = 0; i < ((Intent)hmsScans).length; ++i) {
                Intent hmsScan = hmsScans[i];
                this.mHmsScans.add((HmsScan)hmsScan);
                ImageView img = new ImageView((Context)this);
                img.setImageDrawable(this.getDrawable(R.drawable.scan_scuess));
                Rect rect = hmsScan.getBorderRect();
                Rect other = new Rect();
                other.left = (int)(1080.0f - (float)rect.top * widthScaleFactor);
                other.top = (int)((float)rect.left * heightScaleFactor);
                other.right = (int)(1080.0f - (float)rect.bottom * widthScaleFactor);
                other.bottom = (int)((float)rect.right * heightScaleFactor);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.dip2px(34.0f), this.dip2px(34.0f));
                layoutParams.topMargin = (int)((double)(other.top + other.bottom - this.dip2px(34.0f)) / 2.0);
                layoutParams.leftMargin = (int)((double)(other.right + other.left - this.dip2px(34.0f)) / 2.0);
                img.setId(100 + i);
                img.setOnClickListener((View.OnClickListener)this);
                this.result_layout.addView((View)img, (ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    @SuppressLint(value={"ResourceType"})
    public void onClick(View v) {
        int index = v.getId() - 100;
        HmsScan hmsScan = this.mHmsScans.get(index);
        Intent intent = new Intent();
        intent.putExtra(SCAN_RESULT, hmsScan.getOriginalValue());
        this.setResult(-1, intent);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode != this.SCANPOTHO_CODE && resultCode != -1 && data == null) {
            return;
        }
        try {
            if (this.mode == 1) {
                this.decodeBitmap(MediaStore.Images.Media.getBitmap((ContentResolver)this.getContentResolver(), (Uri)data.getData()));
            } else if (this.mode == 2) {
                this.decodeMultiSyn(MediaStore.Images.Media.getBitmap((ContentResolver)this.getContentResolver(), (Uri)data.getData()));
            } else if (this.mode == 3) {
                this.decodeMultiAsyn(MediaStore.Images.Media.getBitmap((ContentResolver)this.getContentResolver(), (Uri)data.getData()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class SurfaceCallBack
    implements SurfaceHolder.Callback {
        SurfaceCallBack() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            if (!MulitiprocessorActivity.this.isShow) {
                MulitiprocessorActivity.this.isShow = true;
                MulitiprocessorActivity.this.initCamera();
            }
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            MulitiprocessorActivity.this.isShow = false;
        }
    }
}

