/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.alibaba.fastjson.JSONObject;
import com.google.ads.utils.CallbackUtil;
import com.google.ads.utils.LogUtil;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;

public class RewardAds
extends UniModule {
    private RewardedAd mRewardedAd;
    private String mAdUnitId;
    private UniJSCallback mShowCallback;

    @UniJSMethod(uiThread=true)
    public void loadRewardAd(String adUnitId, final UniJSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            CallbackUtil.handleCallback(callback, 1002, "adUnitId cannot be empty");
            return;
        }
        this.mAdUnitId = adUnitId;
        AdRequest adRequest = new AdRequest.Builder().build();
        LogUtil.e("start load google reward ad.");
        RewardedAd.load((Context)this.mUniSDKInstance.getContext(), (String)this.mAdUnitId, (AdRequest)adRequest, (RewardedAdLoadCallback)new RewardedAdLoadCallback(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                String errorMsg = "Ad for " + RewardAds.this.mAdUnitId + " failed to load: " + loadAdError.getMessage();
                LogUtil.e(errorMsg);
                CallbackUtil.handleCallback(callback, 1003, errorMsg);
                RewardAds.this.mRewardedAd = null;
            }

            public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
                String completeMsg = "Ad for " + RewardAds.this.mAdUnitId + " was loaded";
                LogUtil.e(completeMsg);
                CallbackUtil.handleCallback(callback, 201, completeMsg);
                RewardAds.this.mRewardedAd = rewardedAd;
                RewardAds.this.doRewardAdsListener();
            }
        });
    }

    @UniJSMethod(uiThread=true)
    public void showRewardAd(UniJSCallback callback) {
        LogUtil.e("do show google reward ad.");
        this.mShowCallback = callback;
        if (!(this.mUniSDKInstance.getContext() instanceof Activity)) {
            CallbackUtil.handleCallback(this.mShowCallback, 1005, "Error, Ads cannot be displayed on the current page");
            return;
        }
        if (this.mRewardedAd != null) {
            this.mRewardedAd.show((Activity)this.mUniSDKInstance.getContext(), new OnUserEarnedRewardListener(){

                public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                    LogUtil.e("The user earned the reward.");
                    int rewardAmount = rewardItem.getAmount();
                    String rewardType = rewardItem.getType();
                    LogUtil.e("rewardAmount: " + rewardAmount);
                    LogUtil.e("rewardType: " + rewardType);
                    JSONObject rewardRet = new JSONObject();
                    rewardRet.put("rewardAmount", (Object)rewardAmount);
                    rewardRet.put("rewardType", (Object)rewardType);
                    rewardRet.put("code", (Object)1009);
                    CallbackUtil.handleCallback(RewardAds.this.mShowCallback, rewardRet);
                }
            });
        } else {
            LogUtil.e("The rewarded ad wasn't ready yet.");
            CallbackUtil.handleCallback(this.mShowCallback, 1008, "The rewarded ad wasn't ready yet");
        }
    }

    private void doRewardAdsListener() {
        this.mRewardedAd.setFullScreenContentCallback(new FullScreenContentCallback(){

            public void onAdShowedFullScreenContent() {
                String msg = "Google reward ad was shown.";
                LogUtil.e(msg);
                CallbackUtil.handleCallback(RewardAds.this.mShowCallback, 1006, msg);
            }

            public void onAdFailedToShowFullScreenContent(AdError adError) {
                String msg = "Google reward ad failed to show: " + adError.getMessage();
                LogUtil.e(msg);
                CallbackUtil.handleCallback(RewardAds.this.mShowCallback, 1004, msg);
            }

            public void onAdDismissedFullScreenContent() {
                String msg = "Google reward ad was dismissed.";
                LogUtil.e(msg);
                CallbackUtil.handleCallback(RewardAds.this.mShowCallback, 200, msg);
                RewardAds.this.mRewardedAd = null;
            }
        });
    }
}

