/*
 * Decompiled with CFR 0.152.
 */
package com.lianyunzhihui.uniplugin_hwscan;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.RequiresApi;
import com.alibaba.fastjson.JSONArray;
import com.huawei.hms.ml.scan.HmsScan;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class HWScanUtils {
    @RequiresApi(api=24)
    public static int[] scanTypeConversion(JSONArray scanTypes) {
        ArrayList<Integer> scanCodeOption = new ArrayList<Integer>();
        if (scanTypes.contains((Object)"Code128")) {
            scanCodeOption.add(HmsScan.CODE128_SCAN_TYPE);
        }
        if (scanTypes.contains((Object)"Code39")) {
            scanCodeOption.add(HmsScan.CODE39_SCAN_TYPE);
        }
        if (scanTypes.contains((Object)"Code93")) {
            scanCodeOption.add(HmsScan.CODE93_SCAN_TYPE);
        }
        if (scanTypes.contains((Object)"Codabar")) {
            scanCodeOption.add(HmsScan.CODABAR_SCAN_TYPE);
        }
        if (scanTypes.contains((Object)"EAN-13")) {
            scanCodeOption.add(HmsScan.EAN13_SCAN_TYPE);
        }
        if (scanTypes.contains((Object)"EAN-8")) {
            scanCodeOption.add(HmsScan.EAN8_SCAN_TYPE);
        }
        if (scanTypes.contains((Object)"ITF14")) {
            scanCodeOption.add(HmsScan.ITF14_SCAN_TYPE);
        }
        if (scanTypes.contains((Object)"UPC-A")) {
            scanCodeOption.add(HmsScan.UPCCODE_A_SCAN_TYPE);
        }
        if (scanTypes.contains((Object)"UPC-E")) {
            scanCodeOption.add(HmsScan.UPCCODE_E_SCAN_TYPE);
        }
        if (scanTypes.contains((Object)"QR")) {
            scanCodeOption.add(HmsScan.QRCODE_SCAN_TYPE);
        }
        if (scanTypes.contains((Object)"PDF417")) {
            scanCodeOption.add(HmsScan.PDF417_SCAN_TYPE);
        }
        if (scanTypes.contains((Object)"Aztec")) {
            scanCodeOption.add(HmsScan.AZTEC_SCAN_TYPE);
        }
        if (scanTypes.contains((Object)"DataMatrix")) {
            scanCodeOption.add(HmsScan.DATAMATRIX_SCAN_TYPE);
        }
        int[] res = scanCodeOption.stream().mapToInt(Integer::intValue).toArray();
        return res;
    }

    public static int searchCodeTypeWithStr(String codeType) {
        if (codeType.equals("Code128")) {
            return HmsScan.CODE128_SCAN_TYPE;
        }
        if (codeType.equals("Code39")) {
            return HmsScan.CODE39_SCAN_TYPE;
        }
        if (codeType.equals("Code93")) {
            return HmsScan.CODE93_SCAN_TYPE;
        }
        if (codeType.equals("Codabar")) {
            return HmsScan.CODABAR_SCAN_TYPE;
        }
        if (codeType.equals("DataMatrix")) {
            return HmsScan.DATAMATRIX_SCAN_TYPE;
        }
        if (codeType.equals("Aztec")) {
            return HmsScan.AZTEC_SCAN_TYPE;
        }
        if (codeType.equals("PDF417")) {
            return HmsScan.PDF417_SCAN_TYPE;
        }
        if (codeType.equals("QR")) {
            return HmsScan.QRCODE_SCAN_TYPE;
        }
        if (codeType.equals("UPC-E")) {
            return HmsScan.UPCCODE_E_SCAN_TYPE;
        }
        if (codeType.equals("UPC-A")) {
            return HmsScan.UPCCODE_A_SCAN_TYPE;
        }
        if (codeType.equals("ITF14")) {
            return HmsScan.ITF14_SCAN_TYPE;
        }
        if (codeType.equals("EAN-8")) {
            return HmsScan.EAN8_SCAN_TYPE;
        }
        if (codeType.equals("EAN-13")) {
            return HmsScan.EAN13_SCAN_TYPE;
        }
        return -500;
    }

    public static Bitmap convertToBitmap(int width, int height, byte[] data) {
        YuvImage yuv = new YuvImage(data, 17, width, height, null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        yuv.compressToJpeg(new Rect(0, 0, width, height), 100, (OutputStream)stream);
        return BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.toByteArray().length);
    }

    public static int minimization(int i, int j) {
        return i > j ? j : i;
    }

    public static int maximization(int i, int j) {
        return i > j ? i : j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String bitmapToBase64(Bitmap bitmap) {
        String result = null;
        ByteArrayOutputStream baos = null;
        try {
            if (bitmap != null) {
                baos = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
                baos.flush();
                baos.close();
                byte[] bitmapBytes = baos.toByteArray();
                result = Base64.encodeToString((byte[])bitmapBytes, (int)0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (baos != null) {
                    baos.flush();
                    baos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static Bitmap base64ToBitmap(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (string.contains("data:image/png;base64,")) {
                string = string.substring("data:image/png;base64,".length());
            }
            if (string.contains("data:image/jpeg;base64,")) {
                string = string.substring("data:image/jpeg;base64,".length());
            }
        }
        Bitmap bitmap = null;
        try {
            byte[] bitmapArray = Base64.decode((String)string, (int)0);
            bitmap = BitmapFactory.decodeByteArray((byte[])bitmapArray, (int)0, (int)bitmapArray.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }
}

