/*
 * Decompiled with CFR 0.152.
 */
package com.lianyunzhihui.uniplugin_hwscan;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.huawei.hmf.tasks.OnFailureListener;
import com.huawei.hmf.tasks.OnSuccessListener;
import com.huawei.hms.hmsscankit.ScanUtil;
import com.huawei.hms.ml.scan.HmsScan;
import com.huawei.hms.ml.scan.HmsScanAnalyzer;
import com.huawei.hms.ml.scan.HmsScanAnalyzerOptions;
import com.huawei.hms.mlsdk.common.MLFrame;
import com.lianyunzhihui.uniplugin_hwscan.CameraOperation;
import com.lianyunzhihui.uniplugin_hwscan.MulitiprocessorActivity;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;

public class CommonHandler
extends Handler {
    private static final String TAG = "MainHandler";
    private static final double DEFAULT_ZOOM = 1.0;
    private CameraOperation cameraOperation;
    private HandlerThread decodeThread;
    private Handler decodeHandle;
    private Activity activity;
    private int mode;

    public CommonHandler(final Activity activity, CameraOperation cameraOperation, final int mode, final int[] scanTypes) {
        this.cameraOperation = cameraOperation;
        this.activity = activity;
        this.mode = mode;
        this.decodeThread = new HandlerThread("DecodeThread");
        this.decodeThread.start();
        this.decodeHandle = new Handler(this.decodeThread.getLooper()){

            public void handleMessage(Message msg) {
                if (msg == null) {
                    return;
                }
                if (mode == 1 || mode == 2) {
                    HmsScan[] result = CommonHandler.this.decodeSyn(msg.arg1, msg.arg2, (byte[])msg.obj, activity, scanTypes, mode);
                    if (result == null || result.length == 0) {
                        CommonHandler.this.restart(1.0);
                    } else if (TextUtils.isEmpty((CharSequence)result[0].getOriginalValue()) && result[0].getZoomValue() != 1.0) {
                        CommonHandler.this.restart(result[0].getZoomValue());
                    } else if (!TextUtils.isEmpty((CharSequence)result[0].getOriginalValue())) {
                        Message message = new Message();
                        message.what = msg.what;
                        message.obj = result;
                        CommonHandler.this.sendMessage(message);
                        CommonHandler.this.restart(1.0);
                    } else {
                        CommonHandler.this.restart(1.0);
                    }
                }
                if (mode == 3) {
                    CommonHandler.this.decodeAsyn(msg.arg1, msg.arg2, (byte[])msg.obj, activity, scanTypes);
                }
            }
        };
        cameraOperation.startPreview();
        this.restart(1.0);
    }

    private HmsScan[] decodeSyn(int width, int height, byte[] data, Activity activity, int[] types, int mode) {
        Bitmap bitmap = this.convertToBitmap(width, height, data);
        if (mode == 1) {
            HmsScanAnalyzerOptions.Creator creator = new HmsScanAnalyzerOptions.Creator();
            creator.setHmsScanTypes(types[0], types);
            creator.setPhotoMode(false);
            return ScanUtil.decodeWithBitmap((Context)activity, (Bitmap)bitmap, (HmsScanAnalyzerOptions)creator.create());
        }
        if (mode == 2) {
            MLFrame image = MLFrame.fromBitmap((Bitmap)bitmap);
            HmsScanAnalyzerOptions options = new HmsScanAnalyzerOptions.Creator().setHmsScanTypes(types[0], types).create();
            HmsScanAnalyzer analyzer = new HmsScanAnalyzer(options);
            SparseArray result = analyzer.analyseFrame(image);
            if (result != null && result.size() > 0 && result.valueAt(0) != null && !TextUtils.isEmpty((CharSequence)((HmsScan)result.valueAt(0)).getOriginalValue())) {
                HmsScan[] info = new HmsScan[result.size()];
                for (int index = 0; index < result.size(); ++index) {
                    info[index] = (HmsScan)result.valueAt(index);
                }
                return info;
            }
        }
        return null;
    }

    private Bitmap convertToBitmap(int width, int height, byte[] data) {
        YuvImage yuv = new YuvImage(data, 17, width, height, null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        yuv.compressToJpeg(new Rect(0, 0, width, height), 100, (OutputStream)stream);
        return BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.toByteArray().length);
    }

    private void decodeAsyn(int width, int height, byte[] data, Activity activity, int[] types) {
        final Bitmap bitmap = this.convertToBitmap(width, height, data);
        MLFrame image = MLFrame.fromBitmap((Bitmap)bitmap);
        HmsScanAnalyzerOptions options = new HmsScanAnalyzerOptions.Creator().setHmsScanTypes(types[0], types).create();
        HmsScanAnalyzer analyzer = new HmsScanAnalyzer(options);
        analyzer.analyzInAsyn(image).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<HmsScan>>(){

            public void onSuccess(List<HmsScan> hmsScans) {
                if (hmsScans != null && hmsScans.size() > 0 && hmsScans.get(0) != null && !TextUtils.isEmpty((CharSequence)hmsScans.get(0).getOriginalValue())) {
                    HmsScan[] infos = new HmsScan[hmsScans.size()];
                    Message message = new Message();
                    message.obj = hmsScans.toArray(infos);
                    CommonHandler.this.sendMessage(message);
                    CommonHandler.this.restart(1.0);
                } else {
                    CommonHandler.this.restart(1.0);
                }
                bitmap.recycle();
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(Exception e) {
                Log.w((String)CommonHandler.TAG, (Throwable)e);
                CommonHandler.this.restart(1.0);
                bitmap.recycle();
            }
        });
    }

    public void handleMessage(Message message) {
        this.removeMessages(1);
        if (message.what == 0) {
            MulitiprocessorActivity commonActivity1 = (MulitiprocessorActivity)this.activity;
            if (this.mode == 3 || this.mode == 2) {
                MulitiprocessorActivity commonActivity = (MulitiprocessorActivity)this.activity;
                HmsScan[] arr = (HmsScan[])message.obj;
                if (arr.length > 0) {
                    commonActivity.refreshScanResult(arr);
                }
            } else {
                HmsScan[] data = (HmsScan[])message.obj;
                if (data.length <= 0) {
                    return;
                }
                Intent intent = new Intent();
                intent.putExtra("result", data[0].getOriginalValue());
                this.activity.setResult(-1, intent);
                this.activity.finish();
            }
        } else if (message.what == 1) {
            MulitiprocessorActivity mulitiprocessorActivity = (MulitiprocessorActivity)this.activity;
        }
    }

    public void quit() {
        try {
            this.cameraOperation.stopPreview();
            this.decodeHandle.getLooper().quit();
            this.decodeThread.join(500L);
        }
        catch (InterruptedException e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    public void restart(double zoomValue) {
        this.cameraOperation.callbackFrame(this.decodeHandle, zoomValue);
    }

    public void resumePreView() {
        this.cameraOperation.startPreview();
        MulitiprocessorActivity activity1 = (MulitiprocessorActivity)this.activity;
        this.restart(1.0);
    }
}

