/*
 * Decompiled with CFR 0.152.
 */
package com.lianyunzhihui.uniplugin_hwscan;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.alibaba.fastjson.JSONObject;
import com.huawei.hms.ml.scan.HmsScan;
import com.lianyunzhihui.uniplugin_hwscan.HWSanFragment;
import com.lianyunzhihui.uniplugin_hwscan.R;
import com.lianyunzhihui.uniplugin_hwscan.ScanSizeConfig;
import io.dcloud.feature.uniapp.UniSDKInstance;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.ui.action.AbsComponentData;
import io.dcloud.feature.uniapp.ui.component.AbsVContainer;
import io.dcloud.feature.uniapp.ui.component.UniComponent;
import io.dcloud.feature.uniapp.ui.component.UniComponentProp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HWScan
extends UniComponent<LinearLayout> {
    Context mContext;
    LinearLayout mContentViewRootView;
    final int CAMERA_REQ_CODE = 3333;
    final int PERMISSIONS_LENGTH = 2;
    final String TAG = "HWScanComponent";
    private HWSanFragment fragment;

    public HWScan(UniSDKInstance instance, AbsVContainer parent, AbsComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
    }

    @RequiresApi(api=23)
    protected void onCreate() {
        super.onCreate();
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        Log.d((String)"TAG", (String)"onRequestPermissionsResult: ");
        if (requestCode == 3333 && grantResults.length == 2 && grantResults[0] == 0 && grantResults[1] == 0) {
            Log.d((String)"TAG", (String)"onRequestPermissionsResult: \u8fdb\u6765");
        }
    }

    @RequiresApi(api=23)
    protected LinearLayout initComponentHostView(final @NonNull Context context) {
        Log.d((String)"HWScanComponent", (String)"setScanType: \u8bbe\u7f6e\u5c5e\u6027\u5148\u8fdb\u6765\u54172");
        ((Activity)context).requestPermissions(new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE"}, 3333);
        this.mContext = context;
        View view = ((Activity)context).getLayoutInflater().inflate(R.layout.root_layout, null);
        this.mContentViewRootView = new LinearLayout(context);
        this.mContentViewRootView.setOrientation(1);
        LinearLayout.LayoutParams rootLayoutParams = new LinearLayout.LayoutParams(-1, -1);
        this.mContentViewRootView.setLayoutParams((ViewGroup.LayoutParams)rootLayoutParams);
        ViewTreeObserver observer = this.mContentViewRootView.getViewTreeObserver();
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int mScreenHeight1 = HWScan.this.mContentViewRootView.getHeight();
                int mScreenWidth1 = HWScan.this.mContentViewRootView.getWidth();
                int kuangWidth = ScanSizeConfig.scanWeight > mScreenWidth1 ? mScreenWidth1 : ScanSizeConfig.scanWeight;
                int kuangHeight = ScanSizeConfig.scanHeight > mScreenHeight1 ? mScreenHeight1 : ScanSizeConfig.scanHeight;
                ScanSizeConfig.scanWeight = kuangWidth;
                ScanSizeConfig.scanHeight = kuangHeight;
                ScanSizeConfig.left = (mScreenWidth1 - kuangWidth) / 2;
                ScanSizeConfig.right = (mScreenWidth1 + kuangWidth) / 2;
                ScanSizeConfig.top = (mScreenHeight1 - kuangHeight) / 2;
                ScanSizeConfig.bottom = (mScreenHeight1 + kuangHeight) / 2;
                FragmentManager fragmentManager = ((Activity)context).getFragmentManager();
                FragmentTransaction transaction = fragmentManager.beginTransaction();
                HWScan.this.fragment = new HWSanFragment(context);
                HWSanFragment fragment1 = HWScan.this.fragment;
                transaction.replace(R.id.hw_scan, (Fragment)fragment1).commit();
                fragment1.setmOnLightListener(new HWSanFragment.OnLightListener(){

                    @Override
                    public void lightStatu(boolean statu) {
                        HashMap params = new HashMap();
                        HashMap<String, Boolean> number = new HashMap<String, Boolean>();
                        number.put("lightType", statu);
                        params.put("detail", number);
                        HWScan.this.fireEvent("lightType", params);
                    }

                    @Override
                    public void scanResult(JSONObject result) {
                        HashMap params = new HashMap();
                        HashMap<String, String> number = new HashMap<String, String>();
                        number.put("result", result.getString("code"));
                        number.put("path", result.getString("path"));
                        number.put("data", (String)result.getJSONObject("data"));
                        params.put("detail", number);
                        Log.d((String)"HWScanComponent", (String)("\u8bc6\u522b\u7c7b\u578b\u7ed3\u679c: " + params));
                        HWScan.this.fireEvent("scanResult", params);
                    }

                    @Override
                    public void onLightVisible(boolean light) {
                        HashMap params = new HashMap();
                        HashMap<String, Boolean> number = new HashMap<String, Boolean>();
                        number.put("result", light);
                        params.put("detail", number);
                        HWScan.this.fireEvent("lightVisible", params);
                    }
                });
                HWScan.this.mContentViewRootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
        this.mContentViewRootView.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        return this.mContentViewRootView;
    }

    @UniComponentProp(name="continue")
    public void setContinue(boolean scanContinue) {
        Log.d((String)"HWScanComponent", (String)("setContinue: " + scanContinue));
        if (this.fragment != null) {
            this.fragment.setContinuou(scanContinue);
        }
    }

    @UniComponentProp(name="sleepTime")
    public void setSleepTime(int sleepTime) {
        Log.d((String)"HWScanComponent", (String)("sleepTime: " + sleepTime));
        if (this.fragment != null) {
            this.fragment.setSleepTime(sleepTime);
        }
    }

    @UniComponentProp(name="scanType")
    public void setScanType(List<String> scanTypes) {
        Log.d((String)"HWScanComponent", (String)"setScanType: \u8bbe\u7f6e\u5c5e\u6027\u5148\u8fdb\u6765\u5417");
        ArrayList<Integer> scanCodeOption = new ArrayList<Integer>();
        if (scanTypes.contains("Code128")) {
            scanCodeOption.add(HmsScan.CODE128_SCAN_TYPE);
        }
        if (scanTypes.contains("Code39")) {
            scanCodeOption.add(HmsScan.CODE39_SCAN_TYPE);
        }
        if (scanTypes.contains("Code93")) {
            scanCodeOption.add(HmsScan.CODE93_SCAN_TYPE);
        }
        if (scanTypes.contains("Codabar")) {
            scanCodeOption.add(HmsScan.CODABAR_SCAN_TYPE);
        }
        if (scanTypes.contains("EAN-13")) {
            scanCodeOption.add(HmsScan.EAN13_SCAN_TYPE);
        }
        if (scanTypes.contains("EAN-8")) {
            scanCodeOption.add(HmsScan.EAN8_SCAN_TYPE);
        }
        if (scanTypes.contains("ITF14")) {
            scanCodeOption.add(HmsScan.ITF14_SCAN_TYPE);
        }
        if (scanTypes.contains("UPC-A")) {
            scanCodeOption.add(HmsScan.UPCCODE_A_SCAN_TYPE);
        }
        if (scanTypes.contains("UPC-E")) {
            scanCodeOption.add(HmsScan.UPCCODE_E_SCAN_TYPE);
        }
        if (scanTypes.contains("QR")) {
            scanCodeOption.add(HmsScan.QRCODE_SCAN_TYPE);
        }
        if (scanTypes.contains("PDF417")) {
            scanCodeOption.add(HmsScan.PDF417_SCAN_TYPE);
        }
        if (scanTypes.contains("Aztec")) {
            scanCodeOption.add(HmsScan.AZTEC_SCAN_TYPE);
        }
        if (scanTypes.contains("DataMatrix")) {
            scanCodeOption.add(HmsScan.DATAMATRIX_SCAN_TYPE);
        }
        if (this.fragment != null) {
            this.fragment.setScanTypes(scanCodeOption);
        }
    }

    @UniComponentProp(name="scanResultImage")
    public void setScanResultImage(boolean value) {
        ScanSizeConfig.scanResultImage = value;
    }

    @UniComponentProp(name="showScanFrame")
    public void setShowScanFrame(boolean value) {
        ScanSizeConfig.showScanFrame = value;
    }

    @UniComponentProp(name="scanSize")
    public void setScanSize(JSONObject value) {
        if (value.containsKey((Object)"width") && value.getIntValue("width") > 0) {
            int w = value.getIntValue("width");
            int h = value.getIntValue("width");
            if (value.containsKey((Object)"height") && value.getIntValue("height") > 0) {
                h = value.getIntValue("height");
            }
            DisplayMetrics dm = ((Activity)this.mUniSDKInstance.getContext()).getResources().getDisplayMetrics();
            float density = dm.density;
            ScanSizeConfig.scanWeight = (int)(density * (float)w);
            ScanSizeConfig.scanHeight = (int)(density * (float)h);
        }
    }

    @UniComponentProp(name="showScanLine")
    public void setShowScanLine(boolean value) {
        ScanSizeConfig.showScanLine = value;
    }

    @UniComponentProp(name="scanLineColor")
    public void setScanLineColor(String value) {
        if (value == null || TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        ScanSizeConfig.scanLineColor = value;
    }

    @UniComponentProp(name="lineAnimationDuration")
    public void setLineAnimationDuration(String value) {
        if (value == null || TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        ScanSizeConfig.lineAnimationDuration = Integer.getInteger(value);
    }

    @UniJSMethod
    public void remotePause() {
        if (this.fragment != null) {
            this.fragment.remotePause();
        }
    }

    @UniJSMethod
    public void remoteResume() {
        if (this.fragment != null) {
            this.fragment.remoteResume();
        }
    }

    @UniJSMethod
    public void remoteStart() {
        if (this.fragment != null) {
            this.fragment.remoteStart();
        }
    }

    @UniJSMethod
    public void remoteStop() {
        if (this.fragment != null) {
            this.fragment.remoteStop();
        }
    }

    @UniJSMethod
    public void releaseAssets() {
        if (this.fragment != null) {
            this.fragment.releaseAssets();
        }
    }

    @UniJSMethod
    public void switchLight() {
        if (this.fragment != null) {
            this.fragment.switchLight();
        }
    }

    @UniJSMethod
    public void pictureScan() {
        if (this.fragment != null) {
            this.fragment.pictureScanOperation();
        }
    }

    @UniJSMethod
    public void pauseScan() {
        if (this.fragment != null && this.fragment.getRemoteView() != null) {
            this.fragment.pauseContinuouslyScan();
        }
    }

    @UniJSMethod
    public void resumeScan() {
        if (this.fragment != null && this.fragment.getRemoteView() != null) {
            this.fragment.resumeContinuouslyScan();
        }
    }

    public void onActivityDestroy() {
        super.onActivityDestroy();
        this.releaseAssets();
        ScanSizeConfig.isCeartPage = false;
    }

    public void onActivityResume() {
        super.onActivityResume();
        Log.d((String)"HWScanComponent", (String)"onActivityResume: ");
    }

    public void onActivityPause() {
        super.onActivityPause();
        Log.d((String)"HWScanComponent", (String)"onActivityPause: ");
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.d((String)"HWScanComponent", (String)"onActivityResult: \u8fdb\u6765\u4e86");
        if (this.fragment != null) {
            this.fragment.onActivityResult(requestCode, resultCode, data);
        }
    }
}

