/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.ads.utils.CallbackUtil;
import com.google.ads.utils.LogUtil;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;

public class InterstitialAds
extends UniModule {
    private InterstitialAd mInterstitialAd;
    private String mAdUnitId;
    private UniJSCallback mShowCallback;

    @UniJSMethod(uiThread=true)
    public void loadInterstitialAd(String adUnitId, final UniJSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            CallbackUtil.handleCallback(callback, 1002, "adUnitId cannot be empty");
            return;
        }
        this.mAdUnitId = adUnitId;
        AdRequest adRequest = new AdRequest.Builder().build();
        LogUtil.e("start load google interstitial ad.");
        InterstitialAd.load((Context)this.mUniSDKInstance.getContext(), (String)this.mAdUnitId, (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                String errorMsg = "Ad for " + InterstitialAds.this.mAdUnitId + " failed to load: " + loadAdError.getMessage();
                LogUtil.e(errorMsg);
                CallbackUtil.handleCallback(callback, 1003, errorMsg);
                InterstitialAds.this.mInterstitialAd = null;
            }

            public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                String completeMsg = "Ad for " + InterstitialAds.this.mAdUnitId + " was loaded";
                LogUtil.e(completeMsg);
                CallbackUtil.handleCallback(callback, 201, completeMsg);
                InterstitialAds.this.mInterstitialAd = interstitialAd;
                InterstitialAds.this.doInterstitialAdsListener();
            }
        });
    }

    @UniJSMethod(uiThread=true)
    public void showInterstitialAd(UniJSCallback callback) {
        LogUtil.e("do show google interstitial ad.");
        this.mShowCallback = callback;
        if (!(this.mUniSDKInstance.getContext() instanceof Activity)) {
            CallbackUtil.handleCallback(this.mShowCallback, 1005, "Error, Ads cannot be displayed on the current page");
            return;
        }
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.show((Activity)this.mUniSDKInstance.getContext());
        } else {
            LogUtil.e("The interstitial ad wasn't ready yet.");
            CallbackUtil.handleCallback(this.mShowCallback, 1008, "The interstitial ad wasn't ready yet");
        }
    }

    private void doInterstitialAdsListener() {
        this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

            public void onAdShowedFullScreenContent() {
                String msg = "Google interstitial ad was shown.";
                LogUtil.e(msg);
                CallbackUtil.handleCallback(InterstitialAds.this.mShowCallback, 1006, msg);
            }

            public void onAdFailedToShowFullScreenContent(AdError adError) {
                String msg = "Google interstitial ad failed to show: " + adError.getMessage();
                LogUtil.e(msg);
                CallbackUtil.handleCallback(InterstitialAds.this.mShowCallback, 1004, msg);
            }

            public void onAdDismissedFullScreenContent() {
                String msg = "Google interstitial ad was dismissed.";
                LogUtil.e(msg);
                CallbackUtil.handleCallback(InterstitialAds.this.mShowCallback, 200, msg);
                InterstitialAds.this.mInterstitialAd = null;
            }
        });
    }
}

