/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.google.ads.R;
import com.google.ads.utils.LogUtil;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeAdView;
import io.dcloud.feature.uniapp.UniSDKInstance;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.ui.action.AbsComponentData;
import io.dcloud.feature.uniapp.ui.component.AbsVContainer;
import io.dcloud.feature.uniapp.ui.component.UniComponent;
import io.dcloud.feature.uniapp.ui.component.UniComponentProp;
import java.util.HashMap;

public class NativeAds
extends UniComponent<FrameLayout> {
    private NativeAd mNativeAd;
    private String mAdUnitId;
    private UniJSCallback mShowCallback;
    private FrameLayout mFrameLayout;

    public NativeAds(UniSDKInstance instance, AbsVContainer parent, AbsComponentData componentData) {
        super(instance, parent, componentData);
    }

    protected FrameLayout initComponentHostView(@NonNull Context context) {
        this.mFrameLayout = new FrameLayout(context);
        return this.mFrameLayout;
    }

    public void destroy() {
        if (this.mNativeAd != null) {
            this.mNativeAd.destroy();
        }
        super.destroy();
    }

    @UniComponentProp(name="adId")
    public void setAdId(String adId) {
        this.mAdUnitId = adId;
        LogUtil.e("mAdUnitId: " + this.mAdUnitId);
        this.refreshAd();
    }

    private void populateNativeAdView(NativeAd nativeAd, NativeAdView adView) {
        adView.setMediaView((MediaView)adView.findViewById(R.id.ad_media));
        adView.setHeadlineView(adView.findViewById(R.id.ad_headline));
        adView.setBodyView(adView.findViewById(R.id.ad_body));
        adView.setCallToActionView(adView.findViewById(R.id.ad_call_to_action));
        adView.setIconView(adView.findViewById(R.id.ad_app_icon));
        adView.setPriceView(adView.findViewById(R.id.ad_price));
        adView.setStarRatingView(adView.findViewById(R.id.ad_stars));
        adView.setStoreView(adView.findViewById(R.id.ad_store));
        adView.setAdvertiserView(adView.findViewById(R.id.ad_advertiser));
        ((TextView)adView.getHeadlineView()).setText((CharSequence)nativeAd.getHeadline());
        adView.getMediaView().setMediaContent(nativeAd.getMediaContent());
        if (nativeAd.getBody() == null) {
            adView.getBodyView().setVisibility(4);
        } else {
            adView.getBodyView().setVisibility(0);
            ((TextView)adView.getBodyView()).setText((CharSequence)nativeAd.getBody());
        }
        if (nativeAd.getCallToAction() == null) {
            adView.getCallToActionView().setVisibility(4);
        } else {
            adView.getCallToActionView().setVisibility(0);
            ((Button)adView.getCallToActionView()).setText((CharSequence)nativeAd.getCallToAction());
        }
        if (nativeAd.getIcon() == null) {
            adView.getIconView().setVisibility(8);
        } else {
            ((ImageView)adView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(0);
        }
        if (nativeAd.getPrice() == null) {
            adView.getPriceView().setVisibility(4);
        } else {
            adView.getPriceView().setVisibility(0);
            ((TextView)adView.getPriceView()).setText((CharSequence)nativeAd.getPrice());
        }
        if (nativeAd.getStore() == null) {
            adView.getStoreView().setVisibility(4);
        } else {
            adView.getStoreView().setVisibility(0);
            ((TextView)adView.getStoreView()).setText((CharSequence)nativeAd.getStore());
        }
        if (nativeAd.getStarRating() == null) {
            adView.getStarRatingView().setVisibility(4);
        } else {
            ((RatingBar)adView.getStarRatingView()).setRating(nativeAd.getStarRating().floatValue());
            adView.getStarRatingView().setVisibility(0);
        }
        if (nativeAd.getAdvertiser() == null) {
            adView.getAdvertiserView().setVisibility(4);
        } else {
            ((TextView)adView.getAdvertiserView()).setText((CharSequence)nativeAd.getAdvertiser());
            adView.getAdvertiserView().setVisibility(0);
        }
        adView.setNativeAd(nativeAd);
        VideoController vc = nativeAd.getMediaContent().getVideoController();
        if (nativeAd.getMediaContent() != null && nativeAd.getMediaContent().hasVideoContent()) {
            vc.setVideoLifecycleCallbacks(new VideoController.VideoLifecycleCallbacks(){

                public void onVideoEnd() {
                    super.onVideoEnd();
                }
            });
        }
    }

    private void refreshAd() {
        final Context context = this.mUniSDKInstance.getContext();
        AdLoader.Builder builder = new AdLoader.Builder(context, this.mAdUnitId);
        builder.forNativeAd(new NativeAd.OnNativeAdLoadedListener(){

            public void onNativeAdLoaded(NativeAd nativeAd) {
                if (NativeAds.this.mNativeAd != null) {
                    NativeAds.this.mNativeAd.destroy();
                }
                NativeAds.this.mNativeAd = nativeAd;
                NativeAdView adView = (NativeAdView)LayoutInflater.from((Context)context).inflate(R.layout.ad_unified, (ViewGroup)NativeAds.this.mFrameLayout, false);
                NativeAds.this.populateNativeAdView(nativeAd, adView);
                NativeAds.this.mFrameLayout.removeAllViews();
                NativeAds.this.mFrameLayout.addView((View)adView);
            }
        });
        VideoOptions videoOptions = new VideoOptions.Builder().setStartMuted(true).build();
        NativeAdOptions adOptions = new NativeAdOptions.Builder().setVideoOptions(videoOptions).build();
        builder.withNativeAdOptions(adOptions);
        AdLoader adLoader = builder.withAdListener(new AdListener(){

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                LogUtil.e("NativeAds onAdFailedToLoad errorCode: " + loadAdError.getCode() + "  errorMsg: " + loadAdError.getMessage());
                HashMap params = new HashMap();
                HashMap<String, Object> detail = new HashMap<String, Object>();
                detail.put("errorMessage", loadAdError.getMessage());
                detail.put("errorCode", loadAdError.getCode());
                params.put("detail", detail);
                NativeAds.this.fireEvent("onAdFailedToLoad", params);
            }

            public void onAdClicked() {
                super.onAdClicked();
                NativeAds.this.fireEvent("onAdClicked");
                LogUtil.e("NativeAds onAdClicked");
            }

            public void onAdClosed() {
                super.onAdClosed();
                NativeAds.this.fireEvent("onAdClosed");
                LogUtil.e("NativeAds onAdClosed");
            }

            public void onAdImpression() {
                super.onAdImpression();
                NativeAds.this.fireEvent("onAdImpression");
                LogUtil.e("NativeAds onAdImpression");
            }

            public void onAdLoaded() {
                super.onAdLoaded();
                NativeAds.this.fireEvent("onAdLoaded");
                LogUtil.e("NativeAds onAdLoaded");
            }

            public void onAdOpened() {
                super.onAdOpened();
                NativeAds.this.fireEvent("onAdOpened");
                LogUtil.e("NativeAds onAdOpened");
            }

            public void onAdSwipeGestureClicked() {
                super.onAdSwipeGestureClicked();
                NativeAds.this.fireEvent("onAdSwipeGestureClicked");
                LogUtil.e("NativeAds onAdSwipeGestureClicked");
            }
        }).build();
        adLoader.loadAd(new AdRequest.Builder().build());
    }
}

